package ru.yandex.tours.services

import ru.yandex.tours.model.UserVisits
import ru.yandex.tours.model.search.HotelSearchRequest

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 01.06.16
 */
trait UserHistoryService {

  def getRecentItems(uid: Long, limit: Int): Future[Seq[UserVisits.Record]]

  def updateVisit(uid: Long, hotelId: Int, request: HotelSearchRequest, data: UserVisits.PriceData): Future[Unit]

  def putVisit(uid: Long, hotelId: Int, request: HotelSearchRequest, data: UserVisits.PriceData): Future[Unit]
}
