package ru.yandex.tours.stat

import akka.util.Timeout
import ru.yandex.tours.util.http.AsyncHttpClient
import spray.http.Uri.Query
import spray.http._

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 05.03.16
 */
class SpecstatClient(httpClient: AsyncHttpClient, host: String)(implicit ec: ExecutionContext) {

  import SpecstatClient._

  private val headers = List(
    "StatRobotAuth" -> (login + ":" + password),
    "Content-Type" -> MediaTypes.`application/x-www-form-urlencoded`.toString()
  )

  def post(name: String, data: String, timeout: FiniteDuration): Future[(StatusCode, String)] = {
    val uri = Uri(s"https://$host/_api/report/data")
    val q = Query.asBodyData(Seq(
      "name" -> name,
      "data" -> data
    ))
    httpClient.post(uri, q.render(new ByteArrayRendering(data.length)).get, headers)(Timeout(timeout))
  }
}


object SpecstatClient {
  private val login = "robot_darl"
  private val password = "Aetairi8ah"
}