package ru.yandex.tours.tanker

import java.io.InputStream

import com.google.common.base.Charsets
import org.apache.commons.io.IOUtils
import play.api.libs.json.Reads._
import play.api.libs.json.{JsObject, JsString, Json}
import ru.yandex.tours.model.Languages
import ru.yandex.tours.model.Languages._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.03.15
 */
object TankerParser {
  def parse(is: InputStream): Translations = {
    val map = Map.newBuilder[(String, String, Lang), String]

    val json = Json.parse(IOUtils.toString(is, Charsets.UTF_8)).as[JsObject]
    for {
      (lang, forLang: JsObject) <- json.value
      (keySet, forKeySet: JsObject) <- forLang.value
      (key, value: JsString) <- forKeySet.value
    } {
      val language = Languages.withName(lang)
      map += (keySet, key, language) -> value.value.replace("\n", "").trim
    }

    new Translations(map.result())
  }
}
