package ru.yandex.tours.util

import javax.crypto.Cipher
import javax.crypto.spec.{IvParameterSpec, SecretKeySpec}
import javax.xml.bind.DatatypeConverter
import org.apache.commons.codec.binary.Base64


class Decrypter(key: String, iv: String) {
  private lazy val cipher = {
    val keyBytes = DatatypeConverter.parseHexBinary(key)
    val ivBytes = DatatypeConverter.parseHexBinary(iv)
    val cipher = Cipher.getInstance("AES/CBC/PKCS5Padding")
    cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(keyBytes, "AES"),
      new IvParameterSpec(ivBytes, 0, cipher.getBlockSize))
    cipher
  }

  def decrypt(encrypted: String) : String = {
    new String(cipher.doFinal(Base64.decodeBase64(encrypted))).trim
  }

  def tryDecryptSection(keyName: String, value: String ): String = {
    if (keyName == "Authorization") {
      try {
        decrypt(value)
      }
      catch {
        case _: Throwable => value
      }
    } else {
      value
    }
  }
}
