package ru.yandex.tours.util

import reflect.runtime.universe._
import reflect.runtime.currentMirror

/**
  * Author: Vladislav Dolbilov (darl@yandex-team.ru)
  * Created: 01.06.16
  */
object DumpUtils {
  private def indent(s: String) = s.lines.toStream match {
    case h +: t =>
      (("- " + h) +: t.map {
        "| " + _
      }) mkString "\n"
    case _ => "- "
  }

  implicit class RichAny(a: Any) {
    def valueTreeString: String = a match {
      case (k, v) =>
        val valueTree = v.valueTreeString
        if (valueTree.contains("\n")) k.valueTreeString + ":\n" + valueTree
        else k.valueTreeString + ": " + valueTree
      case a: TraversableOnce[_] if a.isEmpty =>
        "<empty>"
      case a: TraversableOnce[_] =>
        a.toStream
          .map(_.valueTreeString)
          .map(indent)
          .mkString("\n")
      case Some(x) ⇒
        x.valueTreeString
      case None ⇒
        "<none>"
      case x: String ⇒
        x.replaceAllLiterally("\\", "\\\\")
          .replaceAllLiterally("\"", "\\\"")
          .replaceAllLiterally("\t", "\\t")
      case a: Product =>
        val b = currentMirror.reflect(a).symbol.typeSignature.members.toStream
          .collect { case a: TermSymbol => a }
          .filterNot(_.isMethod)
          .filterNot(_.isModule)
          .filterNot(_.isClass)
          .map(currentMirror.reflect(a).reflectField)
          .map(f => f.symbol.name.toString.trim -> f.get)
          .reverse
        collection.immutable.ListMap(b: _*).valueTreeString
      case null =>
        "null"
      case _ =>
        a.toString
    }

  }

}