package ru.yandex.tours.util

import java.security.Key
import java.util.Random
import javax.crypto.{Cipher, Mac}
import javax.crypto.spec.{GCMParameterSpec, SecretKeySpec}

import org.apache.commons.codec.binary.Hex

object Encryption {
  private val GCM_TAG_LENGTH = 16
  private val GCM_NONCE_LENGTH = 12
  private val random = new Random()


  def sha256hmac(key: String, data: String) = {
    val mac = Mac.getInstance("HmacSHA256")
    val secretKey = new SecretKeySpec(key.getBytes, "HmacSHA256")
    mac.init(secretKey)
    Hex.encodeHexString(mac.doFinal(data.getBytes))
  }

  def encryptAes(bytes: Array[Byte], key: Key): Array[Byte] = {
    val cipher = Cipher.getInstance("AES/GCM/NoPadding")
    val iv = Array.ofDim[Byte](GCM_NONCE_LENGTH)
    random.nextBytes(iv)
    val gcmSpec = new GCMParameterSpec(GCM_TAG_LENGTH * 8, iv)
    cipher.init(Cipher.ENCRYPT_MODE, key, gcmSpec)
    cipher.doFinal(bytes) ++ iv
  }

  def decryptAes(bytes: Array[Byte], key: Key): Array[Byte] = {
    val cipher = Cipher.getInstance("AES/GCM/NoPadding")
    val iv = bytes.takeRight(GCM_NONCE_LENGTH)
    val gcmSpec = new GCMParameterSpec(GCM_TAG_LENGTH * 8, iv)
    cipher.init(Cipher.DECRYPT_MODE, key, gcmSpec)
    cipher.doFinal(bytes.take(bytes.length - GCM_NONCE_LENGTH))
  }
}
