package ru.yandex.tours.util

import java.io.{ByteArrayInputStream, ByteArrayOutputStream}
import java.nio.charset.Charset
import java.util.zip.{GZIPInputStream, GZIPOutputStream}

import org.apache.commons.io.IOUtils

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 12.03.15
 */
object GZip {

  def compress(buffer: Array[Byte]): Array[Byte] = {
    val out = new ByteArrayOutputStream(buffer.length / 3)
    val os = new GZIPOutputStream(out)
    try os.write(buffer)
    finally IOUtils.closeQuietly(os)
    out.toByteArray
  }

  def compress(s: String, charset: Charset): Array[Byte] =
    compress(s.getBytes(charset))

  def decompress(buffer: Array[Byte]): Array[Byte] = {
    IOUtils.toByteArray(new GZIPInputStream(new ByteArrayInputStream(buffer)))
  }

}
