package ru.yandex.tours.util

import java.io._

import com.google.protobuf.{AbstractMessageLite, Parser}
import ru.yandex.tours.util.Collections._

trait ProtoIO {

  def loadFromBytes[T](bytes: Array[Byte], parser: Parser[T]): Iterator[T] = {
    loadFromStream(new ByteArrayInputStream(bytes), parser)
  }

  def loadFromFile[T](file: File, parser: Parser[T]): Iterator[T] = {
    loadFromStream(new BufferedInputStream(new FileInputStream(file)), parser)
  }

  def loadFromStream[T](is: InputStream, parser: Parser[T]): Iterator[T] = {
    Iterator.continually(parser.parseDelimitedFrom(is)).takeWhile(_ != null).bindTo(is)
  }

  def dump[T <: AbstractMessageLite[_, _]](fileName: String, protos: TraversableOnce[T]): Unit = {
    IO.using(new BufferedOutputStream(new FileOutputStream(fileName))) { os =>
      protos.foreach(_.writeDelimitedTo(os))
    }
  }
}

object ProtoIO extends ProtoIO
