package ru.yandex.tours.util

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 15.09.15
 */
object Speller {
  private val m100s = Seq(12, 13, 14)
  private val m10s = Seq(2, 3, 4)

  /**
   * Speller(sources.size, "источник", "источника", "источников")
   *  1 источник
   *  2 источника
   *  5 источников
   *  11 источников
   *  21 источник
   *  104 источника
   * @return
   */
  def apply(count: Int, f1: String, f2: String, f3: String, addCount: Boolean = true): String = {
    val mod100 = count % 100
    val mod10 = count % 10
    val res =
      if (!m100s.contains(mod100) && m10s.contains(mod10)) f2
      else if (mod100 == 11) f3
      else if (mod10 == 1) f1
      else f3
    if (addCount) count + " " + res
    else res
  }

  def custom(f1: String, f2: String, f3: String, addCount: Boolean = true)(count: Int): String = {
    apply(count, f1, f2, f3, addCount)
  }

  val tours = custom("тур", "тура", "туров") _

  val nights = custom("ночь", "ночи", "ночей") _

  val reviews = custom("отзыв", "отзыва", "отзывов") _

  val subscriptions = custom("подписка", "подписки", "подписок") _

  val hotels = custom("отель", "отеля", "отелей") _

  val regions = custom("регион", "региона", "регионов") _

  val offers = custom("предложение", "предложения", "предложений") _

  val photos = custom("фотография", "фотографии", "фотографий") _
}
