package ru.yandex.tours.util

import java.io.{File, InputStream}

import com.google.common.io.ByteStreams
import org.apache.commons.compress.archivers.tar.{TarArchiveEntry, TarArchiveInputStream}
import org.apache.commons.io.IOUtils

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.09.15
 */
object Tar {
  def readFile[T](is: InputStream, name: String)(action: InputStream => T): T = {
    val tarStream = new TarArchiveInputStream(is)
    try {
      var current = tarStream.getNextTarEntry
      var result: Option[TarArchiveEntry] = None
      while (result.isEmpty && current != null) {
        if (new File(current.getName).getName == name) {
          result = Some(current)
        } else {
          current = tarStream.getNextTarEntry
        }
      }
      result match {
        case None => sys.error(s"File $name not found")
        case Some(fileEntry) =>
          val bytesToRead = fileEntry.getSize
          val fileStream = ByteStreams.limit(tarStream, bytesToRead)

          action(fileStream)
      }
    } finally {
      IOUtils.closeQuietly(tarStream)
    }
  }

  def iterate[T](is: InputStream)(action: (String, InputStream) => T): Unit = {
    val tarStream = new TarArchiveInputStream(is)
    try {
      var current = tarStream.getNextTarEntry
      while (current != null) {
        val bytesToRead = current.getSize
        val fileStream = ByteStreams.limit(tarStream, bytesToRead)
        action(new File(current.getName).getName, fileStream)
        current = tarStream.getNextTarEntry
      }
    } finally {
      IOUtils.closeQuietly(tarStream)
    }
  }
}
