package ru.yandex.tours.util

import _root_.akka.actor._

/* @author berkut@yandex-team.ru */

object UnhandledMessagesHandler extends Logging {

  val ignoredClasses = List(
    classOf[_root_.akka.io.Tcp.Message],
    classOf[_root_.spray.http.HttpResponse]
  )

  private def short(msg: Any) = {
    val str = msg.toString
    if (str.length > 200) str.substring(0, 200) + "..." else msg
  }

  class Listener extends Actor {
    def receive = {
      case m: UnhandledMessage =>
        val clazz = m.message.getClass
        if (!ignoredClasses.exists(_.isAssignableFrom(clazz))) {
          log.warn("Unexpected message: [" + short(m.message) + "](class of " + clazz.getName + "). from " + m.sender + " to " + m.recipient)
        }
      case d: DeadLetter =>
        val clazz = d.message.getClass
        if (!ignoredClasses.exists(_.isAssignableFrom(clazz))) {
          log.warn("Dead letter: [" + short(d.message) + "] from " + d.sender + " to " + d.recipient)
        }
    }
  }

  def initialize(system: ActorSystem): Unit = {
    val listener = system.actorOf(Props[Listener], "unhandled-messages-listener")
    system.eventStream.subscribe(listener, classOf[UnhandledMessage])
    system.eventStream.subscribe(listener, classOf[DeadLetter])
    log.info("Unhandled messages listener was initialized")
  }
}
