package ru.yandex.tours.util

import breeze.generic.UFunc
import breeze.linalg.norm
import breeze.linalg.operators.OpMulInner

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 20.04.16
 */
trait Vectors {

  def cos(vec1: Array[Double], vec2: Array[Double]): Double = {
    require(vec1.length == vec2.length, "arrays of not equal lengths")

    val v1 = breeze.linalg.Vector(vec1)
    val v2 = breeze.linalg.Vector(vec2)

    cosine(v1, v2)
  }

  //scalastyle:off object.name
  object cosine extends UFunc {
    implicit def cosineDistanceFromDotProductAndNorm[T, U](implicit dot: OpMulInner.Impl2[T, U, Double],
                                                           normT: norm.Impl[T, Double],
                                                           normU: norm.Impl[U, Double]): Impl2[T, U, Double] = {
      new Impl2[T, U, Double] {
        override def apply(v: T, v2: U): Double = {
          val denom = norm(v) * norm(v2)
          val dotProduct = dot(v, v2)
          if(denom == 0.0) {
            0.0
          } else {
            dotProduct/denom
          }
        }
      }
    }
  }
  //scalastyle:on object.name
}

object Vectors extends Vectors
