package ru.yandex.tours.util

import java.io.{File, FileFilter, FileInputStream, FileOutputStream}
import java.util.zip.{ZipEntry, ZipOutputStream}

import org.apache.commons.io.IOUtils

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 24.02.16
 */
object Zip {

  /**
   * Zips nested folders.
   * Used for inspiration: http://www.java-forums.org/blogs/java-io/973-how-work-zip-files-java.html
   */
  private def addFolderToZip(folder: File, parentFolder: String, fileFilter: FileFilter, zos: ZipOutputStream) {
    for {
      files <- Option(folder.listFiles())
      file <- files
    } {
      if (file.isDirectory) {
        addFolderToZip(file, parentFolder + "/" + file.getName, fileFilter, zos)
      } else if (fileFilter.accept(file)) {
        zos.putNextEntry(new ZipEntry(parentFolder + "/" + file.getName))
        val bis = new FileInputStream(file)
        IOUtils.copy(bis, zos)
        zos.closeEntry()
      }
    }
  }

  def pack(dir: File, dest: File, fileFilter: FileFilter): Unit = {
    val zip = new ZipOutputStream(new FileOutputStream(dest))
    try {
      addFolderToZip(dir, "", fileFilter, zip)
    } finally {
      zip.close()
    }
  }
}
