package ru.yandex.tours.util.akka

import akka.stream.scaladsl.{Flow, Source}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 28.01.16
 */
trait Streams {
  def flatten[T]: Flow[Iterable[T], T, Unit] =
    Flow[Iterable[T]].flatMapConcat(seq => Source(seq.toVector))
}

object Streams extends Streams
