package ru.yandex.tours.util.collections

import scala.collection.mutable

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 05.06.15
 */
class Bag[T](private val map: mutable.Map[T, Int]) extends mutable.Iterable[T] {
  def this() = this(new mutable.HashMap[T, Int])

  override def iterator: Iterator[T] = map.keysIterator
  override def size: Int = map.size
  override def isEmpty: Boolean = map.isEmpty

  def +=(key: T): Unit = this += (key, 1)
  def +=(key: T, count: Int): Unit = map += key -> (map.getOrElse(key, 0) + count)
  def ++=(bag: Bag[T]): Unit = {
    bag.map.foreach { pair => this += (pair._1, pair._2) }
  }

  def getCount(key: T): Int = map.getOrElse(key, 0)
  def getAndIncrement(key: T): Int = {
    val result = getCount(key)
    this += key
    result
  }

  def keysAsc: Seq[T] = map.toVector.sortBy(_._2).map(_._1)
  def keysDesc: Seq[T] = map.toVector.sortBy(-_._2).map(_._1)

  def entriesDesc: Seq[(T, Int)] = map.toVector.sortBy(-_._2)

  def filterByCount(f: Int => Boolean): Bag[T] = new Bag[T](map.filter(p => f(p._2)))

  def sum: Int = map.values.sum

  def toMap: Map[T, Int] = map.toMap

  override def toString(): String = entriesDesc.mkString("Bag(", ",", ")")
}

object Bag {
  def merge[T](a: Bag[T], b: Bag[T]): Bag[T] = {
    val mergedBag = new Bag[T]
    mergedBag ++= a
    mergedBag ++= b
    mergedBag
  }
}