package ru.yandex.tours.util.collections

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap

import scala.util.Random

class DisjointSet(expectedNumberOfElements: Int = 1000 * 1000) {
  private val map = new Int2IntOpenHashMap(expectedNumberOfElements)
  private val random = new Random()

  def get(x: Int): Int =
    if (map.containsKey(x)) {
      val result = get(map.get(x))
      map.put(x, result)
      result
    } else {
      x
    }

  def join(x: Int, y: Int): Unit = {
    if (random.nextBoolean()) {
      map.put(get(y), get(x))
    } else {
      map.put(get(x), get(y))
    }
  }

  def isSame(x: Int, y: Int): Boolean = get(x) == get(y)
}
