package ru.yandex.tours.util.collections

import java.io._

import com.google.protobuf.{CodedInputStream, CodedOutputStream}
import org.apache.commons.io.FileUtils
import ru.yandex.vertis.curator.recipes.map.ValueSerializer

/**
 * TODO
 */
class FileStash[T](file: File, valueSerializer: ValueSerializer[T]) {

  private var in: FileInputStream = null
  private var cin: CodedInputStream = null
  private var out: FileOutputStream = null
  private var cout: CodedOutputStream = null

  if (file.exists() && file.length() > 0) {
    in = FileUtils.openInputStream(file)
    cin = CodedInputStream.newInstance(in)
    cin.setSizeLimit(Int.MaxValue)
  } else {
    out = FileUtils.openOutputStream(file)
    cout = CodedOutputStream.newInstance(out)
  }

  def push(item: T): Unit = ++=(List(item))

  def +=(item: T): Unit = push(item)
  def ++=(items: Iterable[T]): Unit = {
    require(cout ne null, "FileStash already flipped")
    for (item <- items) {
      val bytes = valueSerializer.serialize(item)
      cout.writeUInt32NoTag(bytes.length)
      cout.writeRawBytes(bytes)
    }
    cout.flush()
    out.flush()
  }

  def pull(): Option[T] = {
    if (in == null) {
      if (out != null) {
        flip()
      } else {
        return None
      }
    }
    if (cin.isAtEnd) {
      try in.close()
      finally file.delete()
      in = null
      cin = null
      None
    } else {
      val len = cin.readRawVarint32()
      val bytes = cin.readRawBytes(len)
      cin.resetSizeCounter()
      valueSerializer.deserialize(bytes).toOption
    }
  }

  private def flip(): Unit = {
    out.close()
    out = null
    cout = null
    in = FileUtils.openInputStream(file)
    cin = CodedInputStream.newInstance(in)
    cin.setSizeLimit(Int.MaxValue)
  }

}
