package ru.yandex.tours.util.collections

import scala.collection.immutable.BitSet

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 20.06.16
 */
class SimpleBitSet(val packed: Long) extends AnyVal {
  def toSet: Set[Int] = {
    BitSet.fromBitMaskNoCopy(Array(packed))
  }
}

object SimpleBitSet {
  def apply(set: Iterable[Int]): SimpleBitSet = {
    var res = 0L
    for (value <- set) {
      res |= 1L << value
    }
    new SimpleBitSet(res)
  }

  def from(value: Long): SimpleBitSet = new SimpleBitSet(value)
}