package ru.yandex.tours.util.collections

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 21.07.15
 */
class Top1[T <: AnyRef](implicit ord: Ordering[T]) {
  private var best: T = _
  def +=(e: T): Unit = {
    if ((best eq null) || ord.lt(e, best)) best = e
  }
  def size: Int = if (isEmpty) 0 else 1
  def isEmpty: Boolean = best eq null
  def nonEmpty: Boolean = best ne null

  def head: T = best
  def toList: List[T] = if (isEmpty) Nil else List(best)
}
