package ru.yandex.tours.util.collections

import ru.yandex.tours.util.lang.RichOrdering

/**
 * Aggregating collection of 3 smallest and unique elements
 */
class Top3[T <: AnyRef, @specialized (Int) E](distinctBy: T => E)(implicit ord: Ordering[T], distinctOrd: Ordering[T]) {
  private val compositeOrd = ord or distinctOrd

  private var uk1: E = _
  private var uk2: E = _
  private var uk3: E = _
  private var top1: T = _
  private var top2: T = _
  private var top3: T = _

  private def set1(e: T, uk: E): Unit = {
    top3 = top2
    uk3 = uk2
    top2 = top1
    uk2 = uk1
    top1 = e
    uk1 = uk
  }
  private def set2(e: T, uk: E): Unit = {
    top3 = top2
    uk3 = uk2
    top2 = e
    uk2 = uk
  }
  private def set3(e: T, uk: E): Unit = {
    top3 = e
    uk3 = uk
  }
  private def rotate12(e: T, uk: E): Unit = {
    top2 = top1
    uk2 = uk1
    top1 = e
    uk1 = uk
  }

  def +=(e: T): Unit = {
    val uk = distinctBy(e)
    if (uk == uk1) {
      if (distinctOrd.lt(e, top1)) top1 = e
    } else if (uk == uk2) {
      if (distinctOrd.lt(e, top2)) {
        if (compositeOrd.lt(e, top1)) rotate12(e, uk)
        else top2 = e
      }
    } else if (uk == uk3) {
      if (distinctOrd.lt(e, top3)) {
        if (compositeOrd.lt(e, top2)) {
          if (compositeOrd.lt(e, top1)) set1(e, uk)
          else set2(e, uk)
        } else top3 = e
      }
    } else if ((top1 eq null) || compositeOrd.lt(e, top1)) {
      set1(e, uk)
    } else if ((top2 eq null) || compositeOrd.lt(e, top2)) {
      set2(e, uk)
    } else if ((top3 eq null) || compositeOrd.lt(e, top3)) {
      set3(e, uk)
    }
  }
  def size = if (top1 eq null) 0 else if (top2 eq null) 1 else if (top3 eq null) 2 else 3
  def isEmpty = top1 eq null
  def nonEmpty = top1 ne null

  def head = top1
  def toList = if (isEmpty) Nil else List(top1, top2, top3).filter(_ ne null)
}