package ru.yandex.tours.util.concurrent

import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.lang.Futures

import scala.concurrent.{ExecutionContext, Future}

object BatchExecutor extends Logging {
  /**
   *
   * @param objects - objects to process
   * @param name - log message
   * @param batchSize - batch size
   * @param action - action over objects
   * @return - number of processed objects
   */
  def executeInBatch[T](objects: Iterator[T],
                        name: String,
                        batchSize: Int,
                        action: Iterable[T] => Future[_])(implicit ec: ExecutionContext): Future[Int] = {
    val futures = objects.grouped(batchSize).zipWithIndex.map {
      case (batch, index) => action(batch).map { _ =>
        val count = index * batchSize + batch.size
        log.info(s"$count $name")
        batch.size
      }
    }
    Futures.lazyFold(futures, 0)(_ + _)
  }
}
