package ru.yandex.tours.util.google

import play.api.libs.json.{JsArray, JsObject, Json}
import ru.yandex.tours.model.BaseModel.Point
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.model.{Languages, LocalizedString}

import scala.collection.JavaConverters._
import scala.concurrent.{ExecutionContext, Future}
import scala.util.control.NoStackTrace

trait GooglePlaceClient {
  def search(request: String, point: Option[Point]): Future[String]

  def searchIds(request: String, point: Option[Point])(implicit ec: ExecutionContext): Future[Seq[String]] = {
    search(request, point).map(parse)
  }

  def search(hotel: PartnerHotel): Future[String] = {
    val name = LocalizedString.fromLangToVal(hotel.getRawHotel.getNameList.asScala)(Languages.ru)
    val point = if (hotel.getRawHotel.hasPoint) Some(hotel.getRawHotel.getPoint) else None
    search(name, point)
  }

  def searchIds(hotel: PartnerHotel)(implicit ec: ExecutionContext): Future[Seq[String]] = {
    search(hotel).map(parse)
  }

  private def parse(response: String) = {
    Json.parse(response).as[JsArray].value.map(_.as[JsObject]).map(_ \ "place_id").map(_.as[String])
  }
}

object GooglePlaceClient {
  case object KeysExhausted extends Exception with NoStackTrace
}
