package ru.yandex.tours.util.google

import java.util.concurrent.atomic.AtomicInteger

import akka.util.Timeout
import play.api.libs.json.{JsArray, JsObject, JsString, Json}
import ru.yandex.tours.model.BaseModel.Point
import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.google.GooglePlaceClient.KeysExhausted
import ru.yandex.tours.util.http.AsyncHttpClient
import spray.http.{StatusCodes, Uri}

import scala.concurrent.duration._
import scala.concurrent.{ExecutionContext, Future}

class HttpGooglePlaceClient(httpClient: AsyncHttpClient)
                           (implicit ec: ExecutionContext) extends GooglePlaceClient with Logging {
  private implicit val to = Timeout(10.seconds)
  private val keys = Array(
    "AIzaSyA-gSO6-QfUQtpYKN8LJ2LZ4Z_4oTIUG_I",
    "AIzaSyBpaSer28CyMcXVvt4FlDNskVKJc2ieJV4",
    "AIzaSyBofka0-QBmuQ1uf8QFtTssnuOKgtAE2vg",
    "AIzaSyDdbrwM5R84BJVfHn0XnZzv0xqfYzgws7s",
    "AIzaSyC92gyUZ4hOTL-sUnlMssb5rx3Z9506wY0",
    "AIzaSyBstlLCfxG4gnXVEhjBJ3wIdgwEvNSJL5M",
    "AIzaSyB8--nUWkE_vcGHt35GjjpBD1JiO3h2egA",
    "AIzaSyCNNeJg8COXRFqimaoUH8L_ixxaL1oIK_I",
    "AIzaSyAGkil198QBpuGCLg3hI_zVg-Mv7vucars",
    "AIzaSyCkjMkv38yYwqhvPOpDdjeCBg874ROn9Uc",
    "AIzaSyBKW2XV1-lZ9Ht1zyYLXd-8k4GLjRlSbHM",
    "AIzaSyA84Kpw3aV0BD1UypJlVu2bBs3EjxJHfjI",
    "AIzaSyC0YmTjwAfx4WxMkGracGMyH7zArQ_QRyU",
    "AIzaSyDvZLTdXw2p4MK4KMM3KRQDBlY2FsdHXs0",
    "AIzaSyBN-eeoqwP0NJZxKOw8l-zdoQ3nMgWHMoc",
    "AIzaSyChOUoHFsKhzmvfpCU_tqi9O3WDHWpGE0U",
    "AIzaSyBlqmkVEBp3f_1uDu8LRJoWtAhiqh3LYko",
    "AIzaSyANpfAFYOnEgMTQ34iQ6YHswFEJNRVXEvU",
    "AIzaSyA7owmsgd963QgFJeZaXxV8xL1Wn5VmAkY",
    "AIzaSyAIXNwlDD15K-GTpEqtKMUULMtppFTmwsE",
    "AIzaSyAYAamwv3NOVutlUY_Y7rW7f8L_He4124U",
    "AIzaSyCiQQzom9JWrt3cgDzXBnAFVz5IcEcIAIY",
    "AIzaSyBCu8HPA2_mWg9ULa4tDqR0vQvzOX1lmvg",
    "AIzaSyC60smmeDwn9l-XOb6Pg0LQ4IOftJt4mfI",
    "AIzaSyDpddE9WDSSC8gvKL4ANwO6JXrkVzjL84k",
    "AIzaSyDMH2KmBbbaQSvPOXxoPUMgYZCIVm6Whys",
    "AIzaSyDTyb1IWPrlvw_xA6ji4VuyOi5faGqZrl4",
    "AIzaSyA-pT9bWVkkV02xyoM08xThl7lgevIEgoU",
    "AIzaSyDn1qVQb5-hjyCYn2zN1sjCba7gN1phwgU",
    "AIzaSyA5v8sR-e-QUg_oCbrQrPr_JFHhYw-Vhss",
    "AIzaSyCQFEmbxN3VSZFDaPUXGkuKZeBoCf4O288",
    "AIzaSyB9CQG5_iHQCrbqEj4J3bQkHQUqtsNi9VY"
  )

  private val currentKey = new AtomicInteger()

  override def search(request: String, point: Option[Point]): Future[String] = {
    val key = currentKey.get
    if (key >= keys.length) return Future.failed(KeysExhausted)
    val params = Seq(
      "query" -> request,
      "key" -> keys(key),
      "types" -> "lodging"
    ) ++ point.toSeq.flatMap { point =>
      Seq(
        "location" -> (point.getLatitude + "," + point.getLongitude),
        "radius" -> "10000"
      )
    }
    val query = Uri("https://maps.googleapis.com/maps/api/place/textsearch/json").withQuery(params: _*)
    httpClient.get(query).flatMap {
      case (StatusCodes.OK, entity) =>
        val json = Json.parse(entity).as[JsObject]
        json \ "status" match {
          case JsString("OK") => Future.successful {
            (json \ "results").as[JsArray].toString()
          }
          case JsString("ZERO_RESULTS") => Future.successful("[]")
          case _ =>
            log.info(s"Request failed, trying next key. Entity: $entity")
            if (currentKey.compareAndSet(key, key + 1)) {
              log.info("Successfully rolled key")
            } else {
              log.info("Can not roll key!")
            }
            search(request, point)
        }
      case (sc, entity) =>
        sys.error(s"Not 200 from google: $sc, $entity")
    }

  }
}
