package ru.yandex.tours.util.google

import ru.yandex.tours.model.BaseModel.Point
import ru.yandex.tours.util.google.GooglePlaceClient.KeysExhausted
import ru.yandex.tours.util.http.{HttpTimeout, HttpMetrics}
import spray.http.StatusCodes

import scala.concurrent.{ExecutionContext, Future}
import scala.util.{Failure, Success}

class InstrumentedHttpGooglePlaceClient(client: HttpGooglePlaceClient)
                                       (implicit ec: ExecutionContext) extends GooglePlaceClient {
  private val metrics = new HttpMetrics("google_downloader", devOnly = true)

  override def search(request: String, point: Option[Point]): Future[String] = {
    val ctx = metrics.start()
    client.search(request, point).andThen {
      case Success(_) => ctx.finish(StatusCodes.OK)
      case Failure(HttpTimeout(e)) => metrics.timeout()
      case Failure(KeysExhausted) => // Do nothing.
      case Failure(e) => ctx.finish(StatusCodes.ServiceUnavailable)
    }
  }
}
