package ru.yandex.tours.util.graph

import scala.collection.mutable
import scala.concurrent.{ExecutionContext, Future}

class BfsWalker(retrieveNeighbours: Int => Future[Set[Int]])(implicit ec: ExecutionContext) {
  def getReachableNeighbours(start: Int): Future[Set[Int]] = {
    val visited = mutable.HashSet.empty[Int]
    val queue = mutable.Queue.empty[Int]
    queue.enqueue(start)
    innerBfs(queue, visited).map(_ => visited.toSet)
  }

  private def innerBfs(queue: mutable.Queue[Int],
                       visited: mutable.Set[Int]): Future[Unit] = {
    if (queue.isEmpty) {
      Future.successful {}
    } else {
      val current = queue.dequeue()
      visited += current
      retrieveNeighbours(current).flatMap { neighbours =>
        neighbours.foreach { x =>
          if (!visited.contains(x)) {
            queue.enqueue(x)
          }
        }
        innerBfs(queue, visited)
      }
    }
  }
}

object BfsWalker {

  def walk[T](start: T, links: T ⇒ Set[T]): Set[T] = {
    val visited = mutable.HashSet.empty[T]
    val queue = mutable.Queue.empty[T]
    queue.enqueue(start)
    while (queue.nonEmpty) {
      val current = queue.dequeue()
      visited += current
      val neighbours = links(current)
      neighbours.foreach { x =>
        if (!visited.contains(x)) {
          queue.enqueue(x)
        }
      }
    }
    visited.toSet
  }

}