package ru.yandex.tours.util.http

import java.io.File

import akka.util.Timeout
import spray.http.{StatusCode, Uri}

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.03.15
 */
trait AsyncHttpClient {
  def get(url: Uri, additionalHeaders: List[(String, String)] = List.empty)
         (implicit requestTimeout: Timeout): Future[(StatusCode, String)]

  def post(url: Uri, body: Array[Byte], additionalHeaders: List[(String, String)] = List.empty)
          (implicit requestTimeout: Timeout): Future[(StatusCode, String)]

  def postFile(url: Uri, file: File, additionalHeaders: List[(String, String)] = List.empty)
              (implicit requestTimeout: Timeout): Future[(StatusCode, String)]

  def put(url: Uri, body: Array[Byte], additionalHeaders: List[(String, String)] = List.empty)
         (implicit requestTimeout: Timeout): Future[(StatusCode, String)]

  def putFile(url: Uri, file: File, additionalHeaders: List[(String, String)] = List.empty)
         (implicit requestTimeout: Timeout): Future[(StatusCode, String)]

  def delete(url: Uri, additionalHeaders: List[(String, String)] = List.empty)
            (implicit requestTimeout: Timeout): Future[(StatusCode, String)]

  def getBytes(url: Uri, additionalHeaders: List[(String, String)] = List.empty)
              (implicit requestTimeout: Timeout): Future[(StatusCode, Array[Byte])]

  def downloadToFile(url: Uri, output: File, additionalHeaders: List[(String, String)] = List.empty)
                    (implicit requestTimeout: Timeout): Future[StatusCode]
}
