package ru.yandex.tours.util.http

import java.util.concurrent.{ExecutionException, TimeoutException}

import akka.pattern.AskTimeoutException

import scala.util.control.NonFatal

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.03.15
 */
object HttpTimeout {
  def unapply(e: Exception): Option[Throwable] = {
    e match {
      case e: ExecutionException if e.getCause.isInstanceOf[TimeoutException] => Some(e)
      case e: AskTimeoutException => Some(e)
      case NonFatal(_) => None
    }
  }
}
