package ru.yandex.tours.util.http

import java.net.URLEncoder

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 05.02.16
 */
object UrlSafe {

  def paramsFromMap(map: Map[String, String]) = {
    map.collect {
      case (name, value) if value.nonEmpty => name + "=" + URLEncoder.encode(value, "UTF-8")
    }.mkString("&")
  }
}
