package ru.yandex.tours.util.io

import java.io.{File, OutputStream, RandomAccessFile}
import java.nio.channels.{Channels, FileChannel}
import java.nio.{ByteBuffer, MappedByteBuffer}

import sun.nio.ch.DirectBuffer

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.01.16
 */
trait ByteBuffers {

  def mmap(file: File): MappedByteBuffer = {
    val raf = new RandomAccessFile(file, "r")
    try {
      val channel = raf.getChannel
      channel.map(FileChannel.MapMode.READ_ONLY, 0, channel.size())
    } finally {
      raf.close()
    }
  }

  def unmap(buffer: ByteBuffer): Unit = {
    val cleaner = buffer.asInstanceOf[DirectBuffer].cleaner()
    cleaner.clean()
  }

  def write(buffer: ByteBuffer, os: OutputStream): Int = {
    val b = buffer.duplicate()
    b.rewind()
    Channels.newChannel(os).write(b)
  }

  def copyBufferToStream(out: OutputStream, in: ByteBuffer, offset: Int, length: Int): Unit = {
    if (in.hasArray) {
      out.write(in.array, in.arrayOffset + offset, length)
    } else {
      var i = 0
      while (i < length) {
        out.write(in.get(offset + i))
        i += 1
      }
    }
  }

  def part(buffer: ByteBuffer, offset: Int, limit: Int): ByteBuffer = {
    val b = buffer.duplicate
    b.position(offset).limit(limit)
    b.slice
  }
}

object ByteBuffers extends ByteBuffers