package ru.yandex.tours.util.lang

import scala.reflect._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 19.10.15
 */
class EnumExtractor[E <: Enum[E] : ClassTag] {
  private val valuesMap = classTag[E].runtimeClass.asInstanceOf[Class[E]]
    .getEnumConstants.map { c => c.name() -> c }
    .toMap

  def unapply(s: String): Option[E] = valuesMap.get(s.toUpperCase)
}
