package ru.yandex.tours.util.lang

import scala.annotation.tailrec
import scala.concurrent.duration.FiniteDuration
import scala.util.control.NonFatal

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 12.01.16
 */
object Retry {
  def withDelay[T](numRetries: Int, delay: FiniteDuration)(action: => T): T = {
    @tailrec def loop(remaining: Int): T = {
      try action
      catch {
        case e: Throwable =>
          if (NonFatal(e)) {
            if (numRetries > 0) {
              Thread.sleep(delay.toMillis)
              loop(remaining - 1)
            } else {
              throw new RuntimeException(s"Action failed after $numRetries times. See last exception in cause", e)
            }
          } else {
            throw e
          }
      }
    }
    loop(numRetries)
  }
}
