package ru.yandex.tours.util.math

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.08.16
 */
object Auc {

  def of(points: Seq[Double]): Double = {
    val size = points.size
    if (size <= 1) 0d
    else {
      points.iterator.sliding(2).withPartial(false).foldLeft(0d) {
        case (sum, Seq(a, b)) ⇒ sum + (a + b) / 2d
      }
    }
  }
}
