package ru.yandex.tours.util.naming

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 30.09.15
 */
class HotelNameId(val id: Long) extends AnyVal {
  def hotelId: Int = (id >> 32).toInt
  def nameIndex: Int = (id & ((1.toLong << 32) - 1)).toInt

  override def toString: String = s"$hotelId/$nameIndex"
}

object HotelNameId {
  def apply(hotelId: Int, nameIndex: Int): HotelNameId = new HotelNameId((hotelId.toLong << 32) + nameIndex)
}