package ru.yandex.tours.util.parsing

import org.apache.commons.lang.StringUtils

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 17.08.15
 */
object CSV {
  def unapplySeq(line: String): Option[Seq[String]] =
    Option(StringUtils.splitPreserveAllTokens(line, ',').toSeq)

  def apply(values: Any*): String =
    values.mkString(",")
}
