package ru.yandex.tours.util.parsing

import org.apache.commons.lang.StringUtils

import scala.collection.mutable

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 07.05.15
 * abstract *-separated key-value
 */
case class SeparatedKeyValue(recordSeparator: String, kvSeparator: String) {
  def apply(data: Iterable[(String, Any)]): String = {
    var first = true
    val sb = new mutable.StringBuilder()
    for ((key, value) <- data) {
      if (first) first = false
      else sb ++= recordSeparator
      sb ++= key
      sb ++= kvSeparator
      sb ++= value.toString
    }
    sb.toString()
  }

  def unapply(line: String): Option[Map[String, String]] = {
    Option(StringUtils.splitPreserveAllTokens(line, recordSeparator)).map { pairs =>
      val res = Map.newBuilder[String, String]
      for (kv <- pairs) {
        kv.indexOf(kvSeparator) match {
          case -1 =>
          case i => res += kv.substring(0, i) -> kv.substring(i + 1)
        }
      }
      res.result()
    }
  }
}
