package ru.yandex.tours.util.parsing

import org.apache.commons.lang.StringUtils

/**
  * Author: Vladislav Dolbilov (darl@yandex-team.ru)
  * Created: 09.02.15
  */
object Tabbed {

  def unapplySeq(line: String): Option[Seq[String]] =
    Option(StringUtils.splitPreserveAllTokens(line, '\t').toSeq)

  def apply(values: Any*): String =
    values.map(x => escape(x.toString)).mkString("\t")

  private def escape(s: String) = {
    s.replaceAll("\t", " ").replaceAll("\n", " ")
  }
}
