package ru.yandex.tours.util.parsing

import org.joda.time.LocalDate

import scala.util.Try

/** Extractor for Booleans */
object BooleanValue {
  def apply(s: String): Option[Boolean] = unapply(s)

  def unapply(s: String): Option[Boolean] = Try(s.toBoolean).toOption
}

/** Extractor for Ints */
object IntValue {
  def apply(s: String): Option[Int] = unapply(s)

  def unapply(s: String): Option[Int] = Try(s.toInt).toOption

  def parse(s: String): Int = s.toInt
}

/** Extractor for Longs */
object LongValue {
  def apply(s: String): Option[Long] = unapply(s)

  def unapply(s: String): Option[Long] = Try(s.toLong).toOption
}

/** Extractor for Doubles */
object DoubleValue {
  def apply(s: String): Option[Double] = unapply(s)

  def unapply(s: String): Option[Double] = Try(s.toDouble).toOption
}

/** Extractor for LocalDate */
object LocalDateValue {
  def apply(s: String): Option[LocalDate] = unapply(s)
  def unapply(s: String): Option[LocalDate] = Try(LocalDate.parse(s)).toOption
}