package ru.yandex.tours.util.s3

import java.io.File

import scala.collection.mutable
import scala.collection.JavaConverters._
import akka.util.Timeout
import spray.http.{StatusCode, Uri}

import scala.concurrent.Future
import scala.concurrent.duration._
import ru.yandex.tours.util.http.AsyncHttpClient
import ru.yandex.travel.s3.S3Auth

class S3Client(client: AsyncHttpClient, baseUrl: String, accessKey: String, secretKey: String) {
  private implicit val timeout = new Timeout(60.seconds)

  private def getUrl(resource: String) = {
    s"$baseUrl/$resource"
  }

  private def makeHeaders(url: Uri, method: String): List[(String, String)] = {
    val headers = mutable.Map[String, String]()
    headers.put("x-amz-content-sha256", S3Auth.UNSIGNED_PAYLOAD)
    S3Auth.computeSignature(url.authority.host.address, url.path.toString, method,
      S3Auth.UNSIGNED_PAYLOAD, accessKey, secretKey, headers.asJava)
    headers.toList
  }

  def get(resource: String) : Future[(StatusCode, Array[Byte])] = {
    client.getBytes(getUrl(resource))
  }

  def upload(resource: String, payload: Array[Byte]): Future[(StatusCode, String)] = {
    val url = getUrl(resource)
    client.put(url, payload, makeHeaders(url, "PUT"))
  }

  def uploadFile(resource: String, payload: File): Future[(StatusCode, String)] = {
    val url = getUrl(resource)
    client.putFile(url, payload, makeHeaders(url, "PUT"))
  }
}
