package ru.yandex.tours.util.spray

import shapeless.{::, HNil}
import spray.http.HttpHeaders.Authorization
import spray.http.{GenericHttpCredentials, StatusCodes}
import spray.routing.Directives._
import spray.routing._
import spray.routing.directives.BasicDirectives
import spray.util._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 24.02.16
 */
trait AuthDirectives {
  private def authTokenFromHeader: Directive1[Option[String]] = {
    BasicDirectives.extract(_.request.headers.findByType[`Authorization`]) map { optAuth =>
      optAuth.flatMap(_.credentials match {
        case GenericHttpCredentials(_, _, params) => params.get("token")
        case _ => None
      })
    }
  }

  private def authToken: Directive1[Option[String]] = (authTokenFromHeader & parameter('auth_key.?)) hmap {
    case optHeader :: authToken :: HNil => authToken.orElse(optHeader)
  }

  def authorize(validTokens: Iterable[String]): Directive0 = authToken flatMap { optToken =>
    if (optToken.isEmpty || !validTokens.exists(_ == optToken.get)) {
      complete(StatusCodes.Forbidden)
    } else {
      pass
    }
  }
}
