package ru.yandex.tours.util.spray

import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.model.util.Paging
import shapeless.{::, HNil}
import spray.http.StatusCodes
import spray.routing.Directives._
import spray.routing._

/* @author berkut@yandex-team.ru */

trait Bindings extends CommonModelDirectives with MetricsDirectives with AuthDirectives {

  val paging: Directive1[Paging] = parameters('page_num.as[Int].?, 'page_size.as[Int].?) hflatMap {
    case optPage :: optPageSize :: HNil =>
      var ans = Paging()
      if (optPage.isDefined) {
        ans = ans.copy(page = optPage.get - 1)
      }
      if (optPageSize.isDefined) {
        ans = ans.copy(pageSize = optPageSize.get)
      }
      provide(ans)
  }

  val requestIndex: Directive1[Int] = parameter('request_index.as[Int] ? 0)

  val experiments: Directive1[Set[String]] = optionalHeaderValueByName("x-experimentid")
    .map(_.getOrElse("").split(',').toSet[String].map(_.trim))


  def withHotel(hotelIndex: HotelsIndex, hotelId: Int)(handler: Hotel => Route): Route = {
    hotelIndex.getHotelById(hotelId) match {
      case Some(hotel) => handler(hotel)
      case None => completeJsonError(StatusCodes.NotFound, "Unknown hotel")
    }
  }
}
