package ru.yandex.tours.util.spray

import java.util.concurrent.ConcurrentHashMap

import ru.yandex.tours.util.http.HttpMetrics
import spray.routing._
import spray.routing.directives.DebuggingDirectives._
import spray.routing.directives.LoggingMagnet

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 07.12.15
 */
trait MetricsDirectives {
  private val metricsCache = new ConcurrentHashMap[String, HttpMetrics]()

  private def getHttpMetrics(name: String): HttpMetrics = {
    metricsCache.get(name) match {
      case null =>
        val created = new HttpMetrics("http." + name, devOnly = true)
        // it's ok to have minimal race here; HttpMetrics is just proxy without internal state
        metricsCache.put(name, created)
        created
      case cached => cached
    }
  }

  protected def metered(name: String): Directive0 = {
    val metrics = getHttpMetrics(name)

    logRequestResponse(LoggingMagnet({ _ =>
      val context = metrics.start()

      (response: Any) => {
        val statusCode = responseToStatusCode(response)
        context.finish(statusCode)
      }
    }))
  }
}
