package ru.yandex.tours.util.spray

import java.util.concurrent.Semaphore

import akka.actor.{Actor, ActorRef, Props}
import com.typesafe.config.Config
import ru.yandex.util.spray.replication.SprayReplicator
import spray.http.Uri

import scala.concurrent.ExecutionContext

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 29.03.16
 */
object Replicator {

  class ForwardingActor(ref: ActorRef) extends Actor {
    override def receive: Receive = {
      case msg => ref forward msg
    }
  }

  def props(ref: ActorRef,
            config: Config)
           (implicit ec: ExecutionContext): Props = {

    if (config.getString("host").nonEmpty) {
      val authority = Uri.Authority(Uri.Host(config.getString("host")), config.getInt("port"))
      val permits = new Semaphore(config.getInt("permits"))

      SprayReplicator.props(ref, ec, authority, permits)
    } else {
      Props(new ForwardingActor(ref))
    }
  }
}
