package ru.yandex.tours.util.spray

import akka.actor.SupervisorStrategy.{Escalate, Restart}
import akka.actor._
import ru.yandex.tours.util.Logging
import spray.routing.{HttpServiceActor, Route}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 12.02.15
 */
class RootHandler private (nextHandler: Props, pingControl: PingControl)
  extends HttpServiceActor {

  private val access = new Access()

  private val handler = context.actorOf(nextHandler, "handler")

  lazy val route = {
    pathPrefix("ping") {
      pingControl.route
    } ~ pathPrefix("loglevel") {
      (pathEndOrSingleSlash & parameters('prefix ? "", 'level ? "")) {
        (prefix, level) =>
          val changed = Logging.setLogLevel(prefix, level)
          val str = if (changed) "Changed" else "Not changed"
          complete(s"$str [$prefix] to [$level]")
      } ~ (path("akka") & parameter('level ? "INFO")) { level =>
        val changed = Logging.setAkkaLogLevel(level)
        val str = if (changed) "Changed" else "Not changed"
        complete(s"$str akka's log level to [$level]")
      }
    } ~ {
      compressResponseIfRequested(()) {
        httpContext => handler ! httpContext
      }
    }
  }

  override def timeoutRoute: Route = { http =>
    access.logTimeout(http.request)
    super.timeoutRoute(http)
  }

  override def receive: Receive = runRoute(logRequestResponse(access.magnet)(sealRoute(route)))

  override def supervisorStrategy: SupervisorStrategy = OneForOneStrategy() {
    case _: ActorInitializationException ⇒ Escalate
    case _: ActorKilledException ⇒ Escalate
    case _: DeathPactException ⇒ Escalate
    case _: Exception => Restart
  }
}

object RootHandler {
  def props(nextHandler: Props, pingControl: PingControl = new PingControl): Props =
    Props(new RootHandler(nextHandler, pingControl))
}
