package ru.yandex.tours.util.spray

import org.apache.commons.lang.StringUtils
import ru.yandex.tours.personalization.UserIdentifiers
import shapeless.{::, HNil}
import spray.routing.Directives._
import spray.routing._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.03.16
 */
trait UserDirectives {
  private val userIdByParameters: Directive1[UserIdentifiers] = parameters('yuid.?, 'uid.?, 'login.?) hmap {
    case yuid :: uid :: login :: HNil => UserIdentifiers(yuid, uid, login)
  }

  private val userIdByHeader = optionalHeaderValueByName("x-userid").map {
    case Some(value) =>
      StringUtils.splitPreserveAllTokens(value, "/") match {
        case Array(uid, login, yuid) => Some(UserIdentifiers(yuid, uid, login))
        case _ => None
      }
    case _ => None
  }

  val userIdentifiers: Directive1[UserIdentifiers] = userIdByHeader & userIdByParameters hmap {
    case byHeader :: byParameters :: HNil => byHeader.getOrElse(byParameters)
  }

  private val userIpByHeader: Directive1[Option[String]] = optionalHeaderValueByName("x-userip")

  val userIp: Directive1[Option[String]] = parameter('user_ip.?) & userIpByHeader hmap {
    case byParam :: byHeader :: HNil => byParam orElse byHeader
  }
}
