package ru.yandex.tours.util.spray.stream

import akka.stream.Materializer
import akka.stream.scaladsl.{Sink, Source}
import spray.httpx.marshalling.Marshaller

import scala.reflect.ClassTag

/**
 * Marshallers for Akka Stream
 *
 * @author dimas
 */
object StreamMarshallers extends {
  /**
   * Creates marshaller for elements from [[Source]].
   * @param batchSize number of elements from source to be sent as a single chunk
   * @param renderer renders elements from source
   * @param materializer materializer is necessary to run Akka Stream Flow
   * @tparam T type of elements from [[Source]]
   */
  def sourceMarshaller[T : ClassTag](renderer: Renderer[T], materializer: Materializer, batchSize: Int): Marshaller[Source[T, _]] = {
    Marshaller[Source[T, _]] { (source, ctx) =>
      val sinkProps = MarshallerActor.props[T](renderer, ctx, batchSize)
      val sink = Sink.actorSubscriber(sinkProps)
      source.runWith(sink)(materializer)
    }
  }
}