package ru.yandex.tours.util.spray.stream

import akka.stream.Materializer
import spray.http.{ContentType, ContentTypes}
import spray.httpx.marshalling.Marshaller

import scala.reflect.ClassTag

trait StreamingResponseSupport {

  implicit def streamingResponseMarshaller[T : ClassTag](implicit materializer: Materializer): Marshaller[StreamingResponse[T]] = {
    streamingResponseMarshaller(128, ContentTypes.`application/octet-stream`)
  }

  def streamingResponseMarshaller[T : ClassTag](batchSize: Int, acceptedCt: ContentType*)
                                               (implicit materializer: Materializer): Marshaller[StreamingResponse[T]] =
    Marshaller.of[StreamingResponse[T]](acceptedCt: _*) {
      case (response, ct, ctx) =>
        response.renderers.find {
          renderer =>
            ct.mediaType == renderer.contentType.mediaType
        } match {
          case Some(renderer) => marshallerFromRenderer(renderer, batchSize).apply(response, ctx)
          case None => ctx.rejectMarshalling(acceptedCt)
        }
    }

  private def marshallerFromRenderer[T : ClassTag](renderer: Renderer[T], batchSize: Int)
                                                  (implicit materializer: Materializer): Marshaller[StreamingResponse[T]] = {
    Marshaller[StreamingResponse[T]] { (response, ctx) =>
      val underlying = StreamMarshallers.sourceMarshaller(renderer, materializer, batchSize)
      underlying(response.source, ctx)
    }
  }
}

object StreamingResponseSupport extends StreamingResponseSupport