package ru.yandex.tours.util.spray.stream.bytestring

import java.io.InputStream

import akka.stream.scaladsl.{Source, StreamConverters}
import akka.util.ByteString
import ru.yandex.tours.util.spray.stream.{Renderer, StreamingResponse}

class ByteStringStreamingResponse(is: InputStream) extends StreamingResponse[ByteString] {
  override def source: Source[ByteString, _] = StreamConverters.fromInputStream(() => is)

  override def renderers: Iterable[Renderer[ByteString]] = Iterable(
    new ByteStringRenderer
  )
}
