package ru.yandex.tours.util.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;

/**
 * @author aherman
 */
public class StringNormalizer {

    public static boolean isSeparator(char ch) {
        return ch != '*' && !Character.isLetterOrDigit(ch);
    }

    @NotNull
    public static String normalizeString(@Nullable String s) {
        return normalizeString(null, s);
    }

    @NotNull
    public static String normalizeString(@Nullable Locale locale, @Nullable String s) {
        if (s == null) {
            return " ";
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        s = s.toLowerCase(locale);
        StringBuilder sb = new StringBuilder(s.length() + 1);
        boolean separator = true;

        for (int i = 0; i < s.length(); i++) {
            char ch = s.charAt(i);
            if (isSeparator(ch)) {
                if (!separator) {
                    sb.append(' ');
                    separator = true;
                }
            } else {
                separator = false;
                if (ch == 'ё') sb.append('е');
                else sb.append(ch);
            }
        }
        if (!separator || sb.length() == 0) {
            sb.append(' ');
        }
        return sb.toString();
    }
}
