package ru.yandex.tours.util.trie;

import ru.yandex.tours.util.trie.mapped.MappedTrie$;

import java.io.OutputStream;

/**
 * @author aherman
 */
public class ArrayTrie implements Trie {
    private static final int ROOT_ID = 0;
    private final TrieNode[] nodes;


    public ArrayTrie(TrieNode[] nodes) {
        this.nodes = nodes;
    }

    @Override
    public int size() {
        return nodes.length;
    }

    public TrieNode[] getNodes() {
        return nodes;
    }

    public TrieNode getRoot() {
        return nodes[ROOT_ID];
    }

    public TrieNode getSon(TrieNode node, char ch) {
        if (!node.isDefined()) {
            return TrieNode.UNDEFINED;
        }
        int sonId = node.getSon(ch);
        if (sonId == TrieNode.UNDEFINED_ID) {
            return TrieNode.UNDEFINED;
        }
        return nodes[sonId];
    }

    public TrieNode getBord(TrieNode node) {
        if (!node.isDefined()) {
            return TrieNode.UNDEFINED;
        }
        int bordId = node.getBord();
        if (bordId == TrieNode.UNDEFINED_ID) {
            return TrieNode.UNDEFINED;
        }
        return nodes[bordId];
    }

    @Override
    public String toString() {
        return "ArrayTrie(size = " + size() + ")";
    }

    @Override
    public void writeTo(OutputStream os) {
        MappedTrie$.MODULE$.writeTo(os, this);
    }
}
