package ru.yandex.tours.util.trie;

import it.unimi.dsi.fastutil.chars.CharIterators;
import it.unimi.dsi.fastutil.ints.IntIterators;

import java.util.Arrays;
import java.util.Iterator;

/**
* @author aherman
*/
public class FastCharMap implements AbstractFastCharMap {
    private final char[] keys;
    private final int[] values;

    public FastCharMap(char[] keys, int[] values) {
        if (keys.length == 0) {
            this.keys = null;
            this.values = null;
        } else {
            this.keys = keys;
            this.values = values;
        }
    }

    @Override
    public int get(char ch, int defaultValue) {
        if (keys == null) {
            return defaultValue;
        }
        int position = -1;
        if (size() > 4) {
            position = Arrays.binarySearch(keys, ch);
        } else {
            for (int i = 0; i < size(); i++) {
                if (keys[i] == ch) {
                    position = i;
                    break;
                }
            }
        }
        if (position < 0) {
            return defaultValue;
        }
        return values[position];
    }

    @Override public void put(char ch, int i) { throw new UnsupportedOperationException(); }

    @Override
    public int size() {
        if (keys == null) {
            return 0;
        }
        return keys.length;
    }

    @Override
    public boolean isEmpty() {
        return keys == null || keys.length == 0;
    }

    @Override
    public Iterator<Character> getKeys() {
        return keys != null ? CharIterators.wrap(keys) : CharIterators.EMPTY_ITERATOR;
    }

    public Iterator<Integer> getValues() {
        return values != null ? IntIterators.wrap(values) : IntIterators.EMPTY_ITERATOR;
    }
}
